require("user.MbPwmRTU")

-- next configuration parameters must be set according power meter settings
local pwm = MbPwmRTU{
    address = "/dev/RS485", 		-- address - /dev/RS485 is the location of special or device files
    speed = 19200,							-- speed - baudrate
    parity = "E",								-- parity - even or odd, used as form of error detecting code
    databits = 8,								-- data bits, least significant bit sent first 
    stopbits = 1,								-- stopbits - stop period of the transmitter
    duplex = "H",								-- duplex - point-to-point system composed of two connected parties or devices that can communicate with one another in both directions, simultaneously
    slaveAddress = 1,						-- address 1-32 of slave device
}

local regTable = {
  -- Date / Time
  { addr=1845, type="UInt16", knx="1/1/1"},			-- Year
  { addr=1846, type="UInt16", knx="1/1/2"},			-- Month & Day
  { addr=1847, type="UInt16", knx="1/1/3"},			-- Hour & Minute
  { addr=1848, type="UInt16", knx="1/1/4"},			-- Milisecond
  -- Wiring Setup
  { addr=2016, type="UInt16", knx="1/1/5"},			-- Power System
  { addr=2017, type="UInt16", knx="1/1/6"},			-- Nominal Frequency
  --Meter Data
  { addr=3000, type="Float32", knx="1/1/7"},			-- I1: phase 1 current
  { addr=3002, type="Float32", knx="1/1/8"},			-- I2: phase 2 current
  { addr=3004, type="Float32", knx="1/1/9"},			-- I3: phase 3 current
  { addr=3020, type="Float32", knx="1/1/10"},			-- Voltage L1-L2
  { addr=3022, type="Float32", knx="1/1/11"},			-- Voltage L2-L3
  { addr=3024, type="Float32", knx="1/1/12"},			-- Voltage L3-L1
  { addr=3028, type="Float32", knx="1/1/13"},			-- Voltage L1-N
  { addr=3030, type="Float32", knx="1/1/14"},			-- Voltage L2-N
  { addr=3032, type="Float32", knx="1/1/15"},			-- Voltage L3-N
  { addr=3060, type="Float32", knx="1/1/16"},			-- Active Power Total
  { addr=3084, type="Float32", knx="1/1/17"},			-- Power Factor Total
  { addr=3110, type="Float32", knx="1/1/18"},			-- Frequency
  { addr=3204, type="Int64", knx="1/1/19"},			-- Total Active Energy Import
  { addr=3256, type="Int64", knx="1/1/20"},			-- Partial Active Energy Import
  { addr=3518, type="Int64", knx="1/1/21"},			-- Active Energy import Phase 1
  { addr=3522, type="Int64", knx="1/1/22"},			-- Active Energy import Phase 2
  { addr=3526, type="Int64", knx="1/1/23"},			-- Active Energy import Phase 3
  
}

pwm:readRegisters(regTable)