require("user.MbPwmRTU")

-- next configuration parameters must be set according power meter settings
local pwm = MbPwmRTU{
    address = "/dev/RS485", 		-- address - /dev/RS485 is the location of special or device files
    speed = 19200,							-- speed - baudrate
    parity = "E",								-- parity - even or odd, used as form of error detecting code
    databits = 8,								-- data bits, least significant bit sent first 
    stopbits = 1,								-- stopbits - stop period of the transmitter
    duplex = "H",								-- duplex - point-to-point system composed of two connected parties or devices that can communicate with one another in both directions, simultaneously
    slaveAddress = 1,						-- address 1-32 of slave device
		knxStartAddr = "3/1/",			-- free knx address format for automatic generation of knx address with increment of group address ("1/2/", "1/2/10" (start at group address 10), 1/2) 
}

local regTable = pwm:allocRegisters{
			{ addr = 3028, type = 'Float32'}, -- Voltage L1-N
			{ addr = 3030, type = 'Float32'}, -- Voltage L2-N
			{ addr = 3032, type = 'Float32'}, -- Voltage L3-N
			{ addr = 3000, type = 'Float32'}, -- I1: phase 1 current
			{ addr = 3002, type = 'Float32'}, -- I2: phase 2 current
			{ addr = 3004, type = 'Float32'}, -- I3: phase 3 current
			{ addr = 3110, type = 'Float32'}, -- Frequency
			{ addr = 3084, type = 'Float32'}, -- Power Factor Total
			{ addr = 3060, type = 'Float32'}, -- Active Power Total
      { addr = 3204, type = 'Int64'},  -- Total Active Energy Import
		}
pwm:readRegisters(regTable)