require("user.MbPwmRTU")

-- next configuration parameters must be set according power meter settings
local pwm = MbPwmRTU{
    address = "/dev/RS485", 		-- address - /dev/RS485 is the location of special or device files
    speed = 19200,					-- speed - baudrate
    parity = "E",					-- parity - even or odd, used as form of error detecting code
    databits = 8,					-- data bits, least significant bit sent first 
    stopbits = 1,					-- stopbits - stop period of the transmitter
    duplex = "H",					-- duplex - point-to-point system composed of two connected parties or devices that can communicate with one another in both directions, simultaneously
    slaveAddress = 1,				-- address 1-32 of slave device
}

regTable = {
	-- System
	{ addr=30, size=20, type="UTF8", knx="1/1/1"},	-- Meter Name
	{ addr=50, size=20, type="UTF8", knx="1/1/2"},	-- Meter Model
	{ addr=70, size=60, type="UTF8", knx="1/1/3"},	-- Manufacturer
	{ addr=130, type="UInt32", knx="1/1/4"},				-- Serial Number
	{ addr=136, size=5, type="UTF8", knx="1/1/5"},	-- Hardware Revision
	{ addr=1637, type="UInt16", knx="1/1/6"},				-- Present Firmware Version
	{ addr=1701, type="UInt16", knx="1/1/7"},				-- Present Language Version
	-- Meter Setup and Status
	{ addr=2004, type="UInt32", knx="1/1/8"},				-- Meter Operation Timer Status
	{ addr=2014, type="UInt16", knx="1/1/9"},				-- Number of Phases
	{ addr=2015, type="UInt16", knx="1/1/10"},			-- Number of Wires
	{ addr=2016, type="UInt16", knx="1/1/11"},			-- Power System Configuration
	{ addr=2017, type="UInt16", knx="1/1/12"},			-- Nominal Frequency
	{ addr=2024, type="UInt16", knx="1/1/13"},			-- Nominal Phase Output
	{ addr=2025, type="UInt16", knx="1/1/14"},			-- Number VTs
	{ addr=2026, type="Float32", knx="1/1/15"},			-- VT Primary
	{ addr=2028, type="UInt16", knx="1/1/16"},			-- VT Secondary
	{ addr=2029, type="UInt16", knx="1/1/17"},			-- Number CTs
	{ addr=2030, type="UInt16", knx="1/1/18"},			-- CT Primary
	{ addr=2031, type="UInt16", knx="1/1/19"},			-- CT Secondary
	{ addr=2036, type="UInt16", knx="1/1/20"},			-- VT Connection Type
	-- Energy Pulse Output Setup
	{ addr=2129, type="UInt16", knx="1/1/21"},			-- Energy Pulse Duration
	{ addr=2131, type="UInt16", knx="1/1/22"},			-- Digital Output Association
	{ addr=2132, type="Float32", knx="1/1/23"},			-- Active Energy Pulse Frequency
	{ addr=2135, type="UInt16", knx="1/1/24"},			-- Digital Output Association
	{ addr=2136, type="Float32", knx="1/1/25"},			-- Reactive Energy Pulse Frequency
	-- Command Interface
	{ addr=5250, type="UInt16", knx="1/1/26"},			-- Requested Command
	{ addr=5252, type="UInt16", knx="1/1/27"},			-- Command Parameter 001
	{ addr=5374, type="UInt16", knx="1/1/28"},			-- Command Parameter 123
	{ addr=5375, type="UInt16", knx="1/1/29"},			-- Command Status
	{ addr=5376, type="UInt16", knx="1/1/30"},			-- Command Result codes
	{ addr=5377, type="UInt16", knx="1/1/31"},			-- Command Data 001
	{ addr=5499, type="UInt16", knx="1/1/32"},			-- Command Data 123
	-- Communications
	{ addr=6500, type="UInt16", knx="1/1/33"},			-- Protocol
	{ addr=6501, type="UInt16", knx="1/1/34"},			-- Address
	{ addr=6502, type="UInt16", knx="1/1/35"},			-- Baud Rate
	{ addr=6503, type="UInt16", knx="1/1/36"},			-- Parity
	-- Input Metering Setup
	{ addr=7032, size=20, type="UTF8", knx="1/1/37"},	-- Label
	{ addr=7052, type="Float32", knx="1/1/38"},			-- Pulse Frequency
	{ addr=7055, type="UInt16", knx="1/1/39"},			-- Digital Input Association
	{ addr=7056, size=20, type="UTF8", knx="1/1/40"},	-- Label
	{ addr=7076, type="Float32", knx="1/1/41"},			-- Pulse Frequency
	{ addr=7079, type="UInt16", knx="1/1/42"},			-- Digital Input Association
	-- Digital Inputs
	{ addr=7274, type="UInt16", knx="1/1/43"},			-- Digital Input 1 Control Mode
	{ addr=7298, type="UInt16", knx="1/1/44"},			-- Digital Input 2 Control Mode
	{ addr=8905, type="Bitmap", knx="1/1/45"},			-- Digital Input Status
	-- Digital Outputs
	{ addr=9673, type="UInt16", knx="1/1/46"},			-- Digital Output 1 Control Mode Status
	{ addr=9681, type="UInt16", knx="1/1/47"},			-- Digital Output 2 Control Mode Status
	{ addr=9667, type="Bitmap", knx="1/1/48"},			-- Digital Output Status
	-- Basic Meter Data
	{ addr=3000, type="Float32", knx="1/1/49"},			-- I1: phase 1 current
	{ addr=3002, type="Float32", knx="1/1/50"},			-- I2: phase 2 current
	{ addr=3004, type="Float32", knx="1/1/51"},			-- I3: phase 3 current
	{ addr=3006, type="Float32", knx="1/1/52"},			-- In: Neutral current
	{ addr=3010, type="Float32", knx="1/1/53"},			-- Current Avg
	{ addr=3020, type="Float32", knx="1/1/54"},			-- Voltage L1-L2
	{ addr=3022, type="Float32", knx="1/1/55"},			-- Voltage L2-L3
	{ addr=3024, type="Float32", knx="1/1/56"},			-- Voltage L3-L1
	{ addr=3026, type="Float32", knx="1/1/57"},			-- Voltage L-L Avg
	{ addr=3028, type="Float32", knx="1/1/58"},			-- Voltage L1-N
	{ addr=3030, type="Float32", knx="1/1/59"},			-- Voltage L2-N
	{ addr=3032, type="Float32", knx="1/1/60"},			-- Voltage L3-N
	{ addr=3036, type="Float32", knx="1/1/61"},			-- Voltage L-N Avg
	{ addr=3054, type="Float32", knx="1/1/62"},			-- Active Power Phase 1
	{ addr=3056, type="Float32", knx="1/1/63"},			-- Active Power Phase 2
	{ addr=3058, type="Float32", knx="1/1/64"},			-- Active Power Phase 3
	{ addr=3060, type="Float32", knx="1/1/65"},			-- Total Active Power
	{ addr=3062, type="Float32", knx="1/1/66"},			-- Reactive Power Phase 1
	{ addr=3064, type="Float32", knx="1/1/67"},			-- Reactive Power Phase 2
	{ addr=3066, type="Float32", knx="1/1/68"},			-- Reactive Power Phase 3
	{ addr=3068, type="Float32", knx="1/1/69"},			-- Total Reactive Power
	{ addr=3070, type="Float32", knx="1/1/70"},			-- Apparent Power Phase 1
	{ addr=3072, type="Float32", knx="1/1/71"},			-- Apparent Power Phase 2
	{ addr=3074, type="Float32", knx="1/1/72"},			-- Apparent Power Phase 3
	{ addr=3076, type="Float32", knx="1/1/73"},			-- Total Apparent Power
	{ addr=3078, type="Float32", knx="1/1/74"},			-- Power Factor Phase 1 (Complex format)
	{ addr=3080, type="Float32", knx="1/1/75"},			-- Power Factor Phase 2 (Complex format)
	{ addr=3082, type="Float32", knx="1/1/76"},			-- Power Factor Phase 3 (Complex format)
	{ addr=3084, type="Float32", knx="1/1/77"},			-- Power Factor Total
	{ addr=3012, type="Float32", knx="1/1/78"},			-- Current Unbalance I1
	{ addr=3014, type="Float32", knx="1/1/79"},			-- Current Unbalance I2
	{ addr=3016, type="Float32", knx="1/1/80"},			-- Current Unbalance I3
	{ addr=3018, type="Float32", knx="1/1/81"},			-- Current Unbalance Worst
	{ addr=3038, type="Float32", knx="1/1/82"},			-- Voltage Unbalance L1-L2
	{ addr=3040, type="Float32", knx="1/1/83"},			-- Voltage Unbalance L2-L3
	{ addr=3042, type="Float32", knx="1/1/84"},			-- Voltage Unbalance L3-L1
	{ addr=3044, type="Float32", knx="1/1/85"},			-- Voltage Unbalance L-L Worst
	{ addr=3046, type="Float32", knx="1/1/86"},			-- Voltage Unbalance L1-N
	{ addr=3048, type="Float32", knx="1/1/87"},			-- Voltage Unbalance L2-N
	{ addr=3050, type="Float32", knx="1/1/88"},			-- Voltage Unbalance L3-N
	{ addr=3052, type="Float32", knx="1/1/89"},			-- Voltage Unbalance L-N Worst
	{ addr=3108, type="Float32", knx="1/1/90"},			-- Tangent Phi, Total
	{ addr=3110, type="Float32", knx="1/1/91"},			-- Frequency
	{ addr=3132, type="Float32", knx="1/1/92"},			-- Temperature
	{ addr=3204, type="Int64", knx="1/1/93"},			-- Total Active Energy Import
	{ addr=3208, type="Int64", knx="1/1/94"},			-- Total Active Energy Export
	{ addr=3220, type="Int64", knx="1/1/95"},			-- Total Reactive Energy Import
	{ addr=3224, type="Int64", knx="1/1/96"},			-- Total Reactive Energy Export
	{ addr=3236, type="Int64", knx="1/1/97"},			-- Total Apparent Energy Import
	{ addr=3240, type="Int64", knx="1/1/98"},			-- Total Apparent Energy Export
	{ addr=3256, type="Int64", knx="1/1/99"},			-- Partial Active Energy Import
	{ addr=3272, type="Int64", knx="1/1/100"},		-- Partial Reactive Energy Import
	{ addr=3288, type="Int64", knx="1/1/101"},		-- Partial Apparent Energy Import
	{ addr=3518, type="Int64", knx="1/1/102"},		-- Active Energy Import Phase 1
	{ addr=3522, type="Int64", knx="1/1/103"},		-- Active Energy Import Phase 2
	{ addr=3526, type="Int64", knx="1/1/104"},		-- Active Energy Import Phase 3
	{ addr=3530, type="Int64", knx="1/1/105"},		-- Reactive Energy Import Phase 1
	{ addr=3534, type="Int64", knx="1/1/106"},		-- Reactive Energy Import Phase 2
	{ addr=3538, type="Int64", knx="1/1/107"},		-- Reactive Energy Import Phase 3
	{ addr=3542, type="Int64", knx="1/1/108"},		-- Apparent Energy Import Phase 1
	{ addr=3546, type="Int64", knx="1/1/109"},		-- Apparent Energy Import Phase 2
	{ addr=3550, type="Int64", knx="1/1/110"},		-- Apparent Energy Import Phase 3
	{ addr=4191, type="UInt16", knx="1/1/111"},		-- Active Tariff
	{ addr=4196, type="Int64", knx="1/1/112"},		-- Rate 1 Active Energy Import
	{ addr=4200, type="Int64", knx="1/1/113"},		-- Rate 2 Active Energy Import
	{ addr=4204, type="Int64", knx="1/1/114"},		-- Rate 3 Active Energy Import
	{ addr=4208, type="Int64", knx="1/1/115"},		-- Rate 4 Active Energy Import
	{ addr=3558, type="Int64", knx="1/1/116"},		-- Input Metering Accumulation Channel 01
	{ addr=3562, type="Int64", knx="1/1/117"},		-- Input Metering Accumulation Channel 02
	-- Demand
	{ addr=3701, type="UInt16", knx="1/1/118"},		-- Demand Method
	{ addr=3702, type="UInt16", knx="1/1/119"},		-- Demand Interval Duration
	{ addr=3766, type="Float32", knx="1/1/120"},	-- Active Power Present Demand
	{ addr=3770, type="Float32", knx="1/1/121"},	-- Active Power Peak Demand
	{ addr=3782, type="Float32", knx="1/1/122"},	-- Reactive Power Present Demand
	{ addr=3786, type="Float32", knx="1/1/123"},	-- Reactive Power Peak Demand
	{ addr=3798, type="Float32", knx="1/1/124"},	-- Apparent Power Present Demand
	{ addr=3802, type="Float32", knx="1/1/125"},	-- Apparent Power Peak Demand
	{ addr=3814, type="Float32", knx="1/1/126"},	-- Current I1 Present Demand
	{ addr=3818, type="Float32", knx="1/1/127"},	-- Current I1 Peak Demand
	{ addr=3830, type="Float32", knx="1/1/128"},	-- Current I2 Present Demand
	{ addr=3834, type="Float32", knx="1/1/129"},	-- Current I2 Peak Demand
	{ addr=3846, type="Float32", knx="1/1/130"},	-- Current I3 Present Demand
	{ addr=3850, type="Float32", knx="1/1/131"},	-- Current I3 Peak Demand
	{ addr=3862, type="Float32", knx="1/1/132"},	-- Current In Present Demand
	{ addr=3866, type="Float32", knx="1/1/133"},	-- Current In Peak Demand
	{ addr=3878, type="Float32", knx="1/1/134"},	-- Current Avg Present Demand
	{ addr=3882, type="Float32", knx="1/1/135"},	-- Current Avg Peak Demand
	-- Minimum Values
	{ addr=27218, type="Float32", knx="1/1/136"},	-- Minimum Current I1
	{ addr=27220, type="Float32", knx="1/1/137"},	-- Minimum Current I2
	{ addr=27222, type="Float32", knx="1/1/138"},	-- Minimum Current I3
	{ addr=27224, type="Float32", knx="1/1/139"},	-- Minimum Current N
	{ addr=27228, type="Float32", knx="1/1/140"},	-- Minimum Current Avg
	{ addr=27238, type="Float32", knx="1/1/141"},	-- Minimum Voltage L1-L2
	{ addr=27240, type="Float32", knx="1/1/142"},	-- Minimum Voltage L2-L3
	{ addr=27242, type="Float32", knx="1/1/143"},	-- Minimum Voltage L3-L1
	{ addr=27244, type="Float32", knx="1/1/144"},	-- Minimum Voltage L-L Avg
	{ addr=27246, type="Float32", knx="1/1/145"},	-- Minimum Voltage L1-N
	{ addr=27248, type="Float32", knx="1/1/146"},	-- Minimum Voltage L2-N
	{ addr=27250, type="Float32", knx="1/1/147"},	-- Minimum Voltage L3-N
	{ addr=27254, type="Float32", knx="1/1/148"},	-- Minimum Voltage L-N Avg
	{ addr=27272, type="Float32", knx="1/1/149"},	-- Minimum Active Power Phase 1
	{ addr=27274, type="Float32", knx="1/1/150"},	-- Minimum Active Power Phase 2
	{ addr=27276, type="Float32", knx="1/1/151"},	-- Minimum Active Power Phase 3
	{ addr=27278, type="Float32", knx="1/1/152"},	-- Minimum Active Power Total
	{ addr=27280, type="Float32", knx="1/1/153"},	-- Minimum Reactive Power Phase 1
	{ addr=27282, type="Float32", knx="1/1/154"},	-- Minimum Reactive Power Phase 2
	{ addr=27284, type="Float32", knx="1/1/155"},	-- Minimum Reactive Power Phase 3
	{ addr=27286, type="Float32", knx="1/1/156"},	-- Minimum Reactive Power Total
	{ addr=27288, type="Float32", knx="1/1/157"},	-- Minimum Apparent Power Phase 1
	{ addr=27290, type="Float32", knx="1/1/158"},	-- Minimum Apparent Power Phase 2
	{ addr=27292, type="Float32", knx="1/1/159"},	-- Minimum Apparent Power Phase 3
	{ addr=27294, type="Float32", knx="1/1/160"},	-- Minimum Apparent Power Total
	{ addr=27306, type="4QFPPF", knx="1/1/161"},	-- Minimum Power Factor Phase 1
	{ addr=27308, type="4QFPPF", knx="1/1/162"},	-- Minimum Power Factor Phase 2
	{ addr=27310, type="4QFPPF", knx="1/1/163"},	-- Minimum Power Factor Phase 3
	{ addr=27312, type="4QFPPF", knx="1/1/164"},	-- Minimum Power Factor Total
	{ addr=27336, type="Float32", knx="1/1/165"},	-- Minimum Tangent Phi, Total
	{ addr=27338, type="Float32", knx="1/1/166"},	-- Minimum THD Current I1
	{ addr=27340, type="Float32", knx="1/1/167"},	-- Minimum THD Current I2
	{ addr=27342, type="Float32", knx="1/1/168"},	-- Minimum THD Current I3
	{ addr=27344, type="Float32", knx="1/1/169"},	-- Minimum THD Current N
	{ addr=27360, type="Float32", knx="1/1/170"},	-- Minimum THD Voltage L1-L2
	{ addr=27362, type="Float32", knx="1/1/171"},	-- Minimum THD Voltage L2-L3
	{ addr=27364, type="Float32", knx="1/1/172"},	-- Minimum THD Voltage L3-L1
	{ addr=27366, type="Float32", knx="1/1/173"},	-- Minimum THD Voltage L-L Avg
	{ addr=27368, type="Float32", knx="1/1/174"},	-- Minimum THD Voltage L1-N
	{ addr=27370, type="Float32", knx="1/1/175"},	-- Minimum THD Voltage L2-N
	{ addr=27372, type="Float32", knx="1/1/176"},	-- Minimum THD Voltage L3-N
	{ addr=27376, type="Float32", knx="1/1/177"},	-- Minimum THD Voltage L-N Avg
	{ addr=27616, type="Float32", knx="1/1/178"},	-- Minimum Frequency
	-- Maximum Values
	{ addr=27694, type="Float32", knx="1/1/179"},	-- Maximum Current I1
	{ addr=27696, type="Float32", knx="1/1/180"},	-- Maximum Current I2
	{ addr=27698, type="Float32", knx="1/1/181"},	-- Maximum Current I3
	{ addr=27700, type="Float32", knx="1/1/182"},	-- Maximum Current N
	{ addr=27704, type="Float32", knx="1/1/183"},	-- Maximum Current Avg
	{ addr=27714, type="Float32", knx="1/1/184"},	-- Maximum Voltage L1-L2
	{ addr=27716, type="Float32", knx="1/1/185"},	-- Maximum Voltage L2-L3
	{ addr=27718, type="Float32", knx="1/1/186"},	-- Maximum Voltage L3-L1
	{ addr=27720, type="Float32", knx="1/1/187"},	-- Maximum Voltage L-L Avg
	{ addr=27722, type="Float32", knx="1/1/188"},	-- Maximum Voltage L1-N
	{ addr=27724, type="Float32", knx="1/1/189"},	-- Maximum Voltage L2-N
	{ addr=27726, type="Float32", knx="1/1/190"},	-- Maximum Voltage L3-N
	{ addr=27730, type="Float32", knx="1/1/191"},	-- Maximum Voltage L-N Avg
	{ addr=27748, type="Float32", knx="1/1/192"},	-- Maximum Active Power Phase 1
	{ addr=27750, type="Float32", knx="1/1/193"},	-- Maximum Active Power Phase 2
	{ addr=27752, type="Float32", knx="1/1/194"},	-- Maximum Active Power Phase 3
	{ addr=27754, type="Float32", knx="1/1/195"},	-- Maximum Active Power Total
	{ addr=27756, type="Float32", knx="1/1/196"},	-- Maximum Reactive Power Phase 1
	{ addr=27758, type="Float32", knx="1/1/197"},	-- Maximum Reactive Power Phase 2
	{ addr=27760, type="Float32", knx="1/1/198"},	-- Maximum Reactive Power Phase 3
	{ addr=27762, type="Float32", knx="1/1/199"},	-- Maximum Reactive Power Total
	{ addr=27764, type="Float32", knx="1/1/200"},	-- Maximum Apparent Power Phase 1
	{ addr=27766, type="Float32", knx="1/1/201"},	-- Maximum Apparent Power Phase 2
	{ addr=27768, type="Float32", knx="1/1/202"},	-- Maximum Apparent Power Phase 3
	{ addr=27770, type="Float32", knx="1/1/203"},	-- Maximum Apparent Power Total
	{ addr=27782, type="4QFPPF", knx="1/1/204"},	-- Maximum Power Factor Phase 1
	{ addr=27784, type="4QFPPF", knx="1/1/205"},	-- Maximum Power Factor Phase 2
	{ addr=27786, type="4QFPPF", knx="1/1/206"},	-- Maximum Power Factor Phase 3
	{ addr=27788, type="4QFPPF", knx="1/1/207"},	-- Maximum Power Factor Total
	{ addr=27812, type="Float32", knx="1/1/208"},	-- Maximum Tangent Phi, Total
	{ addr=27814, type="Float32", knx="1/1/209"},	-- Maximum THD Current I1
	{ addr=27816, type="Float32", knx="1/1/210"},	-- Maximum THD Current I2
	{ addr=27818, type="Float32", knx="1/1/211"},	-- Maximum THD Current I3
	{ addr=27820, type="Float32", knx="1/1/212"},	-- Maximum THD Current N
	{ addr=27836, type="Float32", knx="1/1/213"},	-- Maximum THD Voltage L1-L2
	{ addr=27838, type="Float32", knx="1/1/214"},	-- Maximum THD Voltage L2-L3
	{ addr=27840, type="Float32", knx="1/1/215"},	-- Maximum THD Voltage L3-L1
	{ addr=27842, type="Float32", knx="1/1/216"},	-- Maximum THD Voltage L-L
	{ addr=27844, type="Float32", knx="1/1/217"},	-- Maximum THD Voltage L1-N
	{ addr=27846, type="Float32", knx="1/1/218"},	-- Maximum THD Voltage L2-N
	{ addr=27848, type="Float32", knx="1/1/219"},	-- Maximum THD Voltage L3-N
	{ addr=27852, type="Float32", knx="1/1/220"},	-- Maximum THD Voltage L-N
	{ addr=28092, type="Float32", knx="1/1/221"},	-- Maximum Frequency
	-- MinMax with Time Stamp
	{ addr=45134, type="Float32", knx="1/1/222"},	-- Minimum Current of I1,I2,I3 - Value
	{ addr=45140, type="Float32", knx="1/1/223"},	-- Minimum Power Factor Total - Value
	{ addr=45146, type="Float32", knx="1/1/224"},	-- Maximum Current of I1,I2,I3 - Value
	{ addr=45152, type="Float32", knx="1/1/225"},	-- Maximum Active Power Total - Value
	{ addr=45158, type="Float32", knx="1/1/226"},	-- Maximum Apparent Power Total - Value
	{ addr=45164, type="Float32", knx="1/1/227"},	-- Maximum Power Factor Total - Value
	-- Power Quality
	{ addr=45100, type="Float32", knx="1/1/228"},	-- THD Current I1
	{ addr=45102, type="Float32", knx="1/1/229"},	-- THD Current I2
	{ addr=45104, type="Float32", knx="1/1/230"},	-- THD Current I3
	{ addr=45106, type="Float32", knx="1/1/231"},	-- THD Current Neutral
	{ addr=45108, type="Float32", knx="1/1/232"},	-- THD Phase Current Worst
	{ addr=45110, type="Float32", knx="1/1/233"},	-- THD Voltage L1-L2
	{ addr=45112, type="Float32", knx="1/1/234"},	-- THD Voltage L2-L3
	{ addr=45114, type="Float32", knx="1/1/235"},	-- THD Voltage L3-L1
	{ addr=45116, type="Float32", knx="1/1/236"},	-- THD Voltage L-L Avg
	{ addr=45118, type="Float32", knx="1/1/237"},	-- THD Voltage L-L Worst
	{ addr=45120, type="Float32", knx="1/1/238"},	-- THD Voltage L1-N
	{ addr=45122, type="Float32", knx="1/1/239"},	-- THD Voltage L2-N
	{ addr=45124, type="Float32", knx="1/1/240"},	-- THD Voltage L3-N
	{ addr=45126, type="Float32", knx="1/1/241"},	-- THD Voltage L-N Avg
	{ addr=45128, type="Float32", knx="1/1/242"},	-- THD Voltage L-N Worst
	-- Alarms
	{ addr=11021, type="Bitmap", knx="1/1/243"},	-- Alarm ID (1-16)
	{ addr=11022, type="Bitmap", knx="1/1/244"},	-- Alarm ID (17-32)
	{ addr=11023, type="Bitmap", knx="1/1/245"},	-- Alarm ID (33-40)
	{ addr=11024, type="Bitmap", knx="1/1/246"},	-- Alarm ID (41-56)
	{ addr=11040, type="Bitmap", knx="1/1/247"},	-- Alarm ID (1-16) enable/disable
	{ addr=11041, type="Bitmap", knx="1/1/248"},	-- Alarm ID (17-32) enable/disable
	{ addr=11042, type="Bitmap", knx="1/1/249"},	-- Alarm ID (33-40) enable/disable
	{ addr=11043, type="Bitmap", knx="1/1/250"},	-- Alarm ID (41-56) enable/disable
	{ addr=11078, type="Bitmap", knx="1/1/251"},	-- Alarm ID (1-16) Unacknowledged Alarm
	{ addr=11079, type="Bitmap", knx="1/1/252"},	-- Alarm ID (17-32) Unacknowledged Alarm
	{ addr=11080, type="Bitmap", knx="1/1/253"},	-- Alarm ID (33-40) Unacknowledged Alarm
	{ addr=11081, type="Bitmap", knx="1/1/254"},	-- Alarm ID (41-56) Unacknowledged Alarm
	{ addr=11113, type="UInt16", knx="1/1/255"},	-- Size of Event Queue
	{ addr=11114, type="UInt16", knx="1/2/0"},	-- Number of entries in Event Queue
	{ addr=11115, type="UInt16", knx="1/2/1"},	-- Entry number of Most Recent Event
	{ addr=11116, type="UInt16", knx="1/2/2"},	-- Entry number Entry 001
	{ addr=11121, type="UInt16", knx="1/2/3"},	-- Record Type 001
	{ addr=11122, type="UInt16", knx="1/2/4"},	-- Register Number or Event Code 001
	{ addr=11123, type="UInt16", knx="1/2/5"},	-- Value 001
	{ addr=11127, type="UInt16", knx="1/2/6"},	-- Sequence Number 001
	{ addr=11344, type="UInt16", knx="1/2/7"},	-- Entry number 020
	{ addr=11349, type="UInt16", knx="1/2/8"},	-- Record Type 020
	{ addr=11350, type="UInt16", knx="1/2/9"},	-- Register Number or Event Code 020
	{ addr=11351, type="UInt16", knx="1/2/10"},	-- Value 020
	{ addr=11355, type="UInt16", knx="1/2/11"},	-- Sequence Number 020
	{ addr=12316, type="UInt16", knx="1/2/12"},	-- Size of History Log
	{ addr=12317, type="UInt16", knx="1/2/13"},	-- Number of entries in History Log
	{ addr=12318, type="UInt16", knx="1/2/14"},	-- Entry number of Most Recent Event - history
	{ addr=12319, type="UInt16", knx="1/2/15"},	-- Entry number Entry 001 - history
	{ addr=12324, type="UInt16", knx="1/2/16"},	-- Record Type 001 - history
	{ addr=12325, type="UInt16", knx="1/2/17"},	-- Register Number or Event Code 001 - history
	{ addr=12326, type="UInt16", knx="1/2/18"},	-- Value 001 - history
	{ addr=12330, type="UInt16", knx="1/2/19"},	-- Sequence Number 001 - history
	{ addr=12547, type="UInt16", knx="1/2/20"},	-- Entry number Entry 020 - history
	{ addr=12552, type="UInt16", knx="1/2/21"},	-- Record Type 020 - history
	{ addr=12553, type="UInt16", knx="1/2/22"},	-- Register Number or Event Code 020 - history
	{ addr=12554, type="UInt16", knx="1/2/23"},	-- Value 020 - history
	{ addr=12558, type="UInt16", knx="1/2/24"},	-- Sequence Number 020 - history
	{ addr=14005, type="Float32", knx="1/2/25"},	-- Pickup Setpoint ID1
	{ addr=14007, type="UInt32", knx="1/2/26"},	-- Pickup Time Delay ID1
	{ addr=14009, type="Float32", knx="1/2/27"},	-- Dropout Setpoint ID1
	{ addr=14011, type="UInt32", knx="1/2/28"},	-- Dropout Time Delay ID1
  { addr=14013, type="Bitmap", knx="1/2/29", force=true},	-- Digital Outputs to Associate ID1
	{ addr=14025, type="Float32", knx="1/2/30"},	-- Pickup Setpoint ID2
	{ addr=14027, type="UInt32", knx="1/2/31"},	-- Pickup Time Delay ID2
	{ addr=14029, type="Float32", knx="1/2/32"},	-- Dropout Setpoint ID2
	{ addr=14031, type="UInt32", knx="1/2/33"},	-- Dropout Time Delay ID2
	{ addr=14033, type="Bitmap", knx="1/2/34"},	-- Digital Outputs to Associate ID2
	{ addr=14085, type="Float32", knx="1/2/35"},	-- Pickup Setpoint ID5
	{ addr=14087, type="UInt32", knx="1/2/36"},	-- Pickup Time Delay ID5
	{ addr=14089, type="Float32", knx="1/2/37"},	-- Dropout Setpoint ID5
	{ addr=14091, type="UInt32", knx="1/2/38"},	-- Dropout Time Delay ID5
	{ addr=14093, type="Bitmap", knx="1/2/39"},	-- Digital Outputs to Associate ID5
	{ addr=14105, type="Float32", knx="1/2/40"},	-- Pickup Setpoint ID6
	{ addr=14107, type="UInt32", knx="1/2/41"},	-- Pickup Time Delay ID6
	{ addr=14109, type="Float32", knx="1/2/42"},	-- Dropout Setpoint ID6
	{ addr=14111, type="UInt32", knx="1/2/43"},	-- Dropout Time Delay ID6
	{ addr=14113, type="Bitmap", knx="1/2/44"},	-- Digital Outputs to Associate ID6
	{ addr=14125, type="Float32", knx="1/2/45"},	-- Pickup Setpoint ID7
	{ addr=14127, type="UInt32", knx="1/2/46"},	-- Pickup Time Delay ID7
	{ addr=14129, type="Float32", knx="1/2/47"},	-- Dropout Setpoint ID7
	{ addr=14131, type="UInt32", knx="1/2/48"},	-- Dropout Time Delay ID7
	{ addr=14133, type="Bitmap", knx="1/2/49"},	-- Digital Outputs to Associate ID7
	{ addr=14145, type="Float32", knx="1/2/50"},	-- Pickup Setpoint ID8
	{ addr=14147, type="UInt32", knx="1/2/51"},	-- Pickup Time Delay ID8
	{ addr=14149, type="Float32", knx="1/2/52"},	-- Dropout Setpoint ID8
	{ addr=14151, type="UInt32", knx="1/2/53"},	-- Dropout Time Delay ID8
	{ addr=14153, type="Bitmap", knx="1/2/54"},	-- Digital Outputs to Associate ID8
	{ addr=14165, type="Float32", knx="1/2/55"},	-- Pickup Setpoint ID9
	{ addr=14167, type="UInt32", knx="1/2/56"},	-- Pickup Time Delay ID9
	{ addr=14169, type="Float32", knx="1/2/57"},	-- Dropout Setpoint ID9
	{ addr=14171, type="UInt32", knx="1/2/58"},	-- Dropout Time Delay ID9
	{ addr=14173, type="Bitmap", knx="1/2/59"},	-- Digital Outputs to Associate ID9
	{ addr=14185, type="Float32", knx="1/2/60"},	-- Pickup Setpoint ID10
	{ addr=14187, type="UInt32", knx="1/2/61"},	-- Pickup Time Delay ID10
	{ addr=14189, type="Float32", knx="1/2/62"},	-- Dropout Setpoint ID10
	{ addr=14191, type="UInt32", knx="1/2/63"},	-- Dropout Time Delay ID10
	{ addr=14193, type="Bitmap", knx="1/2/64"},	-- Digital Outputs to Associate ID10
	{ addr=14205, type="Float32", knx="1/2/65"},	-- Pickup Setpoint ID11
	{ addr=14207, type="UInt32", knx="1/2/66"},	-- Pickup Time Delay ID11
	{ addr=14209, type="Float32", knx="1/2/67"},	-- Dropout Setpoint ID11
	{ addr=14211, type="UInt32", knx="1/2/68"},	-- Dropout Time Delay ID11
	{ addr=14213, type="Bitmap", knx="1/2/69"},	-- Digital Outputs to Associate ID11
	{ addr=14225, type="Float32", knx="1/2/70"},	-- Pickup Setpoint ID12
	{ addr=14227, type="UInt32", knx="1/2/71"},	-- Pickup Time Delay ID12
	{ addr=14229, type="Float32", knx="1/2/72"},	-- Dropout Setpoint ID12
	{ addr=14231, type="UInt32", knx="1/2/73"},	-- Dropout Time Delay ID12
	{ addr=14233, type="Bitmap", knx="1/2/74"},	-- Digital Outputs to Associate ID12
	{ addr=14245, type="Float32", knx="1/2/75"},	-- Pickup Setpoint ID13
	{ addr=14247, type="UInt32", knx="1/2/76"},	-- Pickup Time Delay ID13
	{ addr=14249, type="Float32", knx="1/2/77"},	-- Dropout Setpoint ID13
	{ addr=14251, type="UInt32", knx="1/2/78"},	-- Dropout Time Delay ID13
	{ addr=14253, type="Bitmap", knx="1/2/79"},	-- Digital Outputs to Associate ID13
	{ addr=14305, type="Float32", knx="1/2/80"},	-- Pickup Setpoint ID16
	{ addr=14307, type="UInt32", knx="1/2/81"},	-- Pickup Time Delay ID16
	{ addr=14309, type="Float32", knx="1/2/82"},	-- Dropout Setpoint ID16
	{ addr=14311, type="UInt32", knx="1/2/83"},	-- Dropout Time Delay ID16
	{ addr=14313, type="Bitmap", knx="1/2/84"},	-- Digital Outputs to Associate ID16
	{ addr=14425, type="Float32", knx="1/2/85"},	-- Pickup Setpoint ID22
	{ addr=14427, type="UInt32", knx="1/2/86"},	-- Pickup Time Delay ID22
	{ addr=14429, type="Float32", knx="1/2/87"},	-- Dropout Setpoint ID22
	{ addr=14431, type="UInt32", knx="1/2/88"},	-- Dropout Time Delay ID22
	{ addr=14433, type="Bitmap", knx="1/2/89"},	-- Digital Outputs to Associate ID22
	{ addr=14545, type="Float32", knx="1/2/90"},	-- Pickup Setpoint ID28
	{ addr=14547, type="UInt32", knx="1/2/91"},	-- Pickup Time Delay ID28
	{ addr=14549, type="Float32", knx="1/2/92"},	-- Dropout Setpoint ID28
	{ addr=14551, type="UInt32", knx="1/2/93"},	-- Dropout Time Delay ID28
	{ addr=14553, type="Bitmap", knx="1/2/94"},	-- Digital Outputs to Associate ID28
	{ addr=14825, type="Float32", knx="1/2/95"},	-- Pickup Setpoint ID30
	{ addr=14827, type="UInt32", knx="1/2/96"},	-- Pickup Time Delay ID30
	{ addr=14829, type="Float32", knx="1/2/97"},	-- Dropout Setpoint ID30
	{ addr=14831, type="UInt32", knx="1/2/98"},	-- Dropout Time Delay ID30
	{ addr=14833, type="Bitmap", knx="1/2/99"},	-- Digital Outputs to Associate ID30
	{ addr=14865, type="Float32", knx="1/2/100"},	-- Pickup Setpoint ID31
	{ addr=14867, type="UInt32", knx="1/2/101"},	-- Pickup Time Delay ID31
	{ addr=14869, type="Float32", knx="1/2/102"},	-- Dropout Setpoint ID31
	{ addr=14871, type="UInt32", knx="1/2/103"},	-- Dropout Time Delay ID31
	{ addr=14873, type="Bitmap", knx="1/2/104"},	-- Digital Outputs to Associate ID31
	{ addr=14905, type="Float32", knx="1/2/105"},	-- Pickup Setpoint ID32
	{ addr=14907, type="UInt32", knx="1/2/106"},	-- Pickup Time Delay ID32
	{ addr=14909, type="Float32", knx="1/2/107"},	-- Dropout Setpoint ID32
	{ addr=14911, type="UInt32", knx="1/2/108"},	-- Dropout Time Delay ID32
	{ addr=14913, type="Bitmap", knx="1/2/109"},	-- Digital Outputs to Associate ID32
	{ addr=14942, type="UInt16", knx="1/2/110"},	-- Source Register ID41
	{ addr=14945, type="Float32", knx="1/2/111"},	-- Pickup Setpoint ID41
	{ addr=14947, type="UInt32", knx="1/2/112"},	-- Pickup Time Delay ID41
	{ addr=14949, type="Float32", knx="1/2/113"},	-- Dropout Setpoint ID41
	{ addr=14951, type="UInt32", knx="1/2/114"},	-- Dropout Time Delay ID41
	{ addr=14953, type="Bitmap", knx="1/2/115"},	-- Digital Outputs to Associate ID41
	-- Energy Log
	{ addr=45600, type="UInt16", knx="1/2/116"},	-- Enable/Disable Day
	{ addr=45601, type="UInt16", knx="1/2/117"},	-- Maximum Entry Number Day
	{ addr=45602, type="UInt16", knx="1/2/118"},	-- Current Entry Number Day
	{ addr=45603, type="UInt16", knx="1/2/119"},	-- Latest Entry ID Day
	{ addr=45604, type="UInt16", knx="1/2/120"},	-- Oldest Entry ID Day
	{ addr=45605, type="Int64", knx="1/2/121"},	-- Real-time Value of Current Day
	{ addr=45613, type="Int64", knx="1/2/122"},	-- Entry 001 Value Day
	{ addr=45965, type="Int64", knx="1/2/123"},	-- Entry 045 Value Day
	{ addr=45969, type="UInt16", knx="1/2/124"},	-- Enable/Disable Week
	{ addr=45970, type="UInt16", knx="1/2/125"},	-- Maximum Entry Number Week
	{ addr=45971, type="UInt16", knx="1/2/126"},	-- Current Entry Number Week
	{ addr=45972, type="UInt16", knx="1/2/127"},	-- Latest Entry ID Week
	{ addr=45973, type="UInt16", knx="1/2/128"},	-- Oldest Entry ID Week
	{ addr=45974, type="Int64", knx="1/2/129"},	-- Real-time Value of Current Week
	{ addr=45982, type="Int64", knx="1/2/130"},	-- Entry 001 Value Week
	{ addr=46134, type="Int64", knx="1/2/131"},	-- Entry 020 Value Week
  
	{ addr=46138, type="UInt16", knx="1/2/132"},	-- Enable/Disable Month
	{ addr=46139, type="UInt16", knx="1/2/133"},	-- Maximum Entry Number Month
	{ addr=46140, type="UInt16", knx="1/2/134"},	-- Current Entry Number Month
	{ addr=46141, type="UInt16", knx="1/2/135"},	-- Latest Entry ID Month
	{ addr=46142, type="UInt16", knx="1/2/136"},	-- Oldest Entry ID Month
	{ addr=46143, type="Int64", knx="1/2/137"},	-- Real-time Value of Current Month
	{ addr=46151, type="Int64", knx="1/2/138"},	-- Entry 001 Value Month
	{ addr=46247, type="Int64", knx="1/2/139"},	-- Entry 013 Value Month
	{ addr=45500, type="UInt16", knx="1/2/140"},	-- Flex Method
	{ addr=45501, type="UInt16", knx="1/2/141"},	-- Flex Log Interval Duration
}
pwm:readRegisters(regTable)