require("user.MbPwmRTU")

-- next configuration parameters must be set according power meter settings
local pwm = MbPwmRTU{
    address = "/dev/RS485", 		-- address - /dev/RS485 is the location of special or device files
    speed = 19200,							-- speed - baudrate
    parity = "E",								-- parity - even or odd, used as form of error detecting code
    databits = 8,								-- data bits, least significant bit sent first 
    stopbits = 1,								-- stopbits - stop period of the transmitter
    duplex = "H",								-- duplex - point-to-point system composed of two connected parties or devices that can communicate with one another in both directions, simultaneously
    slaveAddress = 1,						-- address 1-32 of slave device
}

local regTable = {
	-- Date / Time
	{ addr=1845, type="UInt16", knx="1/1/1"},               -- Year
	{ addr=1846, type="UInt16", knx="1/1/2"},               -- Month & Day
	{ addr=1847, type="UInt16", knx="1/1/3"},               -- Hour & Minute
	{ addr=1848, type="UInt16", knx="1/1/4"},               -- Milisecond
	-- Wiring Setup
	{ addr=2016, type="UInt16", knx="1/1/5"},               -- Power System
	{ addr=2017, type="UInt16", knx="1/1/6"},               -- Nominal Frequency
	--Energy Pulse Output Setup
	{ addr=2129, type="UInt16", knx="1/1/7"},               -- Pulse Duration
	{ addr=2132, type="Float32", knx="1/1/8"},               -- Pulse Constant
	--Meter Data
	{ addr=3000, type="Float32", knx="1/1/9"},               -- I1: phase 1 current
	{ addr=3002, type="Float32", knx="1/1/10"},               -- I2: phase 2 current
	{ addr=3004, type="Float32", knx="1/1/11"},               -- I3: phase 3 current
	{ addr=3020, type="Float32", knx="1/1/12"},               -- Voltage L1-L2
	{ addr=3022, type="Float32", knx="1/1/13"},               -- Voltage L2-L3
	{ addr=3024, type="Float32", knx="1/1/14"},               -- Voltage L3-L1
	{ addr=3028, type="Float32", knx="1/1/15"},               -- Voltage L1-N
	{ addr=3030, type="Float32", knx="1/1/16"},               -- Voltage L2-N
	{ addr=3032, type="Float32", knx="1/1/17"},               -- Voltage L3-N
	{ addr=3060, type="Float32", knx="1/1/18"},               -- Active Power Total
	{ addr=3068, type="Float32", knx="1/1/19"},               -- Reactive Power Total
	{ addr=3076, type="Float32", knx="1/1/20"},               -- Apparent Power Total
	{ addr=3084, type="Float32", knx="1/1/21"},               -- Power Factor Total
	{ addr=3110, type="Float32", knx="1/1/22"},               -- Frequency
	{ addr=3204, type="Int64", knx="1/1/23"},               -- Total Active Energy Import
	{ addr=3208, type="Int64", knx="1/1/24"},               -- Total Active Energy Export
	{ addr=3220, type="Int64", knx="1/1/25"},               -- Total Reactive Energy Import
	{ addr=3224, type="Int64", knx="1/1/26"},               -- Total Reactive Energy Export
	{ addr=3256, type="Int64", knx="1/1/27"},               -- Partial Active Energy Import
	{ addr=3272, type="Int64", knx="1/1/28"},               -- Partial Reactive Energy Import
	{ addr=3518, type="Int64", knx="1/1/29"},               -- Active Energy import Phase 1
	{ addr=3522, type="Int64", knx="1/1/30"},               -- Active Energy import Phase 2
	{ addr=3526, type="Int64", knx="1/1/31"},               -- Active Energy import Phase 3
	{ addr=3558, type="Int64", knx="1/1/32"},               -- Input Metering
	{ addr=4191, type="Int64", knx="1/1/33"},               -- Active Tariff
	{ addr=4196, type="Int64", knx="1/1/34"},               -- Rate A Active Energy Import
	{ addr=4200, type="Int64", knx="1/1/35"},               -- Rate B Active Energy Import
	{ addr=4204, type="Int64", knx="1/1/36"},               -- Rate C Active Energy Import
	{ addr=4208, type="Int64", knx="1/1/37"},               -- Rate D Active Energy Import
	{ addr=45005, type="Bitmap", knx="1/1/38"},     -- Activated Status
	{ addr=45006, type="Bitmap", knx="1/1/39"},     -- Unacknowledged Status
}

pwm:readRegisters(regTable)
