require("user.MbPwmRTU")

-- next configuration parameters must be set according power meter settings
local pwm = MbPwmRTU{
    address = "/dev/RS485", 		-- address - /dev/RS485 is the location of special or device files
    speed = 19200,							-- speed - baudrate
    parity = "E",								-- parity - even or odd, used as form of error detecting code
    databits = 8,								-- data bits, least significant bit sent first 
    stopbits = 1,								-- stopbits - stop period of the transmitter
    duplex = "H",								-- duplex - point-to-point system composed of two connected parties or devices that can communicate with one another in both directions, simultaneously
    slaveAddress = 1,						-- address 1-32 of slave device
}

local regTable = {
	-- System
	{ addr=30, size=20, type="UTF8", knx="1/1/1"},	-- Meter Name
	{ addr=50, size=20, type="UTF8", knx="1/1/2"},	-- Meter Model
	{ addr=70, size=60, type="UTF8", knx="1/1/3"},	-- Manufacturer
	{ addr=130, type="UInt32", knx="1/1/4"},				-- Serial Number
	{ addr=136, size=5, type="UTF8", knx="1/1/5"},	-- Hardware Revision
	{ addr=1637, type="UInt16", knx="1/1/6"},				-- Present Firmware Version
	{ addr=1701, type="UInt16", knx="1/1/7"},				-- Present Language Version
	-- Meter Setup and Status
	{ addr=2004, type="UInt32", knx="1/1/8"},				-- Meter Operation Timer Status
	{ addr=2014, type="UInt16", knx="1/1/9"},				-- Number of Phases
	{ addr=2015, type="UInt16", knx="1/1/10"},			-- Number of Wires
	{ addr=2016, type="UInt16", knx="1/1/11"},			-- Power System Configuration
	{ addr=2017, type="UInt16", knx="1/1/12"},			-- Nominal Frequency
	{ addr=2024, type="UInt16", knx="1/1/13"},			-- Nominal Phase Output
	{ addr=2025, type="UInt16", knx="1/1/14"},			-- Number VTs
	{ addr=2026, type="Float32", knx="1/1/15"},			-- VT Primary
	{ addr=2028, type="UInt16", knx="1/1/16"},			-- VT Secondary
	{ addr=2029, type="UInt16", knx="1/1/17"},			-- Number CTs
	{ addr=2030, type="UInt16", knx="1/1/18"},			-- CT Primary
	{ addr=2031, type="UInt16", knx="1/1/19"},			-- CT Secondary
	{ addr=2036, type="UInt16", knx="1/1/20"},			-- VT Connection Type  	
	-- Command Interface
	{ addr=5250, type="UInt16", knx="1/1/21"},			-- Requested Command
	{ addr=5252, type="UInt16", knx="1/1/22"},			-- Command Parameter 001
	{ addr=5374, type="UInt16", knx="1/1/23"},			-- Command Parameter 123
	{ addr=5375, type="UInt16", knx="1/1/24"},			-- Command Status
	{ addr=5376, type="UInt16", knx="1/1/25"},			-- Command Result codes
	{ addr=5377, type="UInt16", knx="1/1/26"},			-- Command Data 001
	{ addr=5499, type="UInt16", knx="1/1/27"},			-- Command Data 123
  -- Communications
	{ addr=6500, type="UInt16", knx="1/1/28"},			-- Protocol
	{ addr=6501, type="UInt16", knx="1/1/29"},			-- Address
	{ addr=6502, type="UInt16", knx="1/1/30"},			-- Baud Rate
	{ addr=6503, type="UInt16", knx="1/1/31"},			-- Parity
	-- Basic Meter Data
	{ addr=3000, type="Float32", knx="1/1/32"},			-- I1: phase 1 current
	{ addr=3002, type="Float32", knx="1/1/33"},			-- I2: phase 2 current
	{ addr=3004, type="Float32", knx="1/1/34"},			-- I3: phase 3 current
	{ addr=3006, type="Float32", knx="1/1/35"},			-- In: Neutral current
	{ addr=3010, type="Float32", knx="1/1/36"},			-- Current Avg
	{ addr=3020, type="Float32", knx="1/1/37"},			-- Voltage L1-L2
	{ addr=3022, type="Float32", knx="1/1/38"},			-- Voltage L2-L3
	{ addr=3024, type="Float32", knx="1/1/39"},			-- Voltage L3-L1
	{ addr=3026, type="Float32", knx="1/1/40"},			-- Voltage L-L Avg
	{ addr=3028, type="Float32", knx="1/1/41"},			-- Voltage L1-N
	{ addr=3030, type="Float32", knx="1/1/42"},			-- Voltage L2-N
	{ addr=3032, type="Float32", knx="1/1/43"},			-- Voltage L3-N
	{ addr=3036, type="Float32", knx="1/1/44"},			-- Voltage L-N Avg
	{ addr=3054, type="Float32", knx="1/1/45"},			-- Active Power Phase 1
	{ addr=3056, type="Float32", knx="1/1/46"},			-- Active Power Phase 2
	{ addr=3058, type="Float32", knx="1/1/47"},			-- Active Power Phase 3
	{ addr=3060, type="Float32", knx="1/1/48"},			-- Total Active Power
	{ addr=3062, type="Float32", knx="1/1/49"},			-- Reactive Power Phase 1
	{ addr=3064, type="Float32", knx="1/1/50"},			-- Reactive Power Phase 2
	{ addr=3066, type="Float32", knx="1/1/51"},			-- Reactive Power Phase 3
	{ addr=3068, type="Float32", knx="1/1/52"},			-- Total Reactive Power
	{ addr=3070, type="Float32", knx="1/1/53"},			-- Apparent Power Phase 1
	{ addr=3072, type="Float32", knx="1/1/54"},			-- Apparent Power Phase 2
	{ addr=3074, type="Float32", knx="1/1/55"},			-- Apparent Power Phase 3
	{ addr=3076, type="Float32", knx="1/1/56"},			-- Total Apparent Power
	{ addr=3078, type="Float32", knx="1/1/57"},			-- Power Factor Phase 1 (Complex format)
	{ addr=3080, type="Float32", knx="1/1/58"},			-- Power Factor Phase 2 (Complex format)
	{ addr=3082, type="Float32", knx="1/1/59"},			-- Power Factor Phase 3 (Complex format)
	{ addr=3084, type="Float32", knx="1/1/60"},			-- Power Factor Total
	{ addr=3012, type="Float32", knx="1/1/61"},			-- Current Unbalance I1
	{ addr=3014, type="Float32", knx="1/1/62"},			-- Current Unbalance I2
	{ addr=3016, type="Float32", knx="1/1/63"},			-- Current Unbalance I3
	{ addr=3018, type="Float32", knx="1/1/64"},			-- Current Unbalance Worst
	{ addr=3038, type="Float32", knx="1/1/65"},			-- Voltage Unbalance L1-L2
	{ addr=3040, type="Float32", knx="1/1/66"},			-- Voltage Unbalance L2-L3
	{ addr=3042, type="Float32", knx="1/1/67"},			-- Voltage Unbalance L3-L1
	{ addr=3044, type="Float32", knx="1/1/68"},			-- Voltage Unbalance L-L Worst
	{ addr=3046, type="Float32", knx="1/1/69"},			-- Voltage Unbalance L1-N
	{ addr=3048, type="Float32", knx="1/1/70"},			-- Voltage Unbalance L2-N
	{ addr=3050, type="Float32", knx="1/1/71"},			-- Voltage Unbalance L3-N
	{ addr=3052, type="Float32", knx="1/1/72"},			-- Voltage Unbalance L-N Worst
	{ addr=3108, type="Float32", knx="1/1/73"},			-- Tangent Phi, Total
	{ addr=3110, type="Float32", knx="1/1/74"},			-- Frequency
	{ addr=3132, type="Float32", knx="1/1/75"},			-- Temperature 
	{ addr=3204, type="Int64", knx="1/1/76"},			-- Total Active Energy Import
	{ addr=3208, type="Int64", knx="1/1/77"},			-- Total Active Energy Export
	{ addr=3220, type="Int64", knx="1/1/78"},			-- Total Reactive Energy Import
	{ addr=3224, type="Int64", knx="1/1/79"},		  -- Total Reactive Energy Export
	{ addr=3236, type="Int64", knx="1/1/80"},			-- Total Apparent Energy Import
	{ addr=3240, type="Int64", knx="1/1/81"},			-- Total Apparent Energy Export
	{ addr=3256, type="Int64", knx="1/1/82"},			-- Partial Active Energy Import
	{ addr=3272, type="Int64", knx="1/1/83"},		-- Partial Reactive Energy Import
	{ addr=3288, type="Int64", knx="1/1/84"},		-- Partial Apparent Energy Import
	{ addr=3518, type="Int64", knx="1/1/85"},		-- Active Energy Import Phase 1
	{ addr=3522, type="Int64", knx="1/1/86"},		-- Active Energy Import Phase 2
	{ addr=3526, type="Int64", knx="1/1/87"},		-- Active Energy Import Phase 3
	{ addr=3530, type="Int64", knx="1/1/88"},		-- Reactive Energy Import Phase 1
	{ addr=3534, type="Int64", knx="1/1/89"},		-- Reactive Energy Import Phase 2
	{ addr=3538, type="Int64", knx="1/1/90"},		-- Reactive Energy Import Phase 3
	{ addr=3542, type="Int64", knx="1/1/91"},		-- Apparent Energy Import Phase 1
	{ addr=3546, type="Int64", knx="1/1/92"},		-- Apparent Energy Import Phase 2
	{ addr=3550, type="Int64", knx="1/1/93"},		-- Apparent Energy Import Phase 3
	{ addr=4191, type="UInt16", knx="1/1/94"},		-- Active Tariff
	{ addr=4196, type="Int64", knx="1/1/95"},		-- Rate 1 Active Energy Import
	{ addr=4200, type="Int64", knx="1/1/96"},		-- Rate 2 Active Energy Import
	{ addr=4204, type="Int64", knx="1/1/97"},		-- Rate 3 Active Energy Import
	{ addr=4208, type="Int64", knx="1/1/98"},		-- Rate 4 Active Energy Import 
	-- Demand
	{ addr=3701, type="UInt16", knx="1/1/99"},		-- Demand Method
	{ addr=3702, type="UInt16", knx="1/1/100"},		-- Demand Interval Duration
	{ addr=3766, type="Float32", knx="1/1/101"},	-- Active Power Present Demand
	{ addr=3770, type="Float32", knx="1/1/102"},	-- Active Power Peak Demand
	{ addr=3782, type="Float32", knx="1/1/103"},	-- Reactive Power Present Demand
	{ addr=3786, type="Float32", knx="1/1/104"},	-- Reactive Power Peak Demand
	{ addr=3798, type="Float32", knx="1/1/105"},	-- Apparent Power Present Demand
	{ addr=3802, type="Float32", knx="1/1/106"},	-- Apparent Power Peak Demand
	{ addr=3814, type="Float32", knx="1/1/107"},	-- Current I1 Present Demand
	{ addr=3818, type="Float32", knx="1/1/108"},	-- Current I1 Peak Demand
	{ addr=3830, type="Float32", knx="1/1/109"},	-- Current I2 Present Demand
	{ addr=3834, type="Float32", knx="1/1/110"},	-- Current I2 Peak Demand
	{ addr=3846, type="Float32", knx="1/1/111"},	-- Current I3 Present Demand
	{ addr=3850, type="Float32", knx="1/1/112"},	-- Current I3 Peak Demand
	{ addr=3862, type="Float32", knx="1/1/113"},	-- Current In Present Demand
	{ addr=3866, type="Float32", knx="1/1/114"},	-- Current In Peak Demand
	{ addr=3878, type="Float32", knx="1/1/115"},	-- Current Avg Present Demand
	{ addr=3882, type="Float32", knx="1/1/116"},	-- Current Avg Peak Demand
	-- Minimum Values 
	{ addr=27218, type="Float32", knx="1/1/117"},	-- Minimum Current I1
	{ addr=27220, type="Float32", knx="1/1/118"},	-- Minimum Current I2
	{ addr=27222, type="Float32", knx="1/1/119"},	-- Minimum Current I3
	{ addr=27224, type="Float32", knx="1/1/120"},	-- Minimum Current N
	{ addr=27228, type="Float32", knx="1/1/121"},	-- Minimum Current Avg
	{ addr=27238, type="Float32", knx="1/1/122"},	-- Minimum Voltage L1-L2
	{ addr=27240, type="Float32", knx="1/1/123"},	-- Minimum Voltage L2-L3
	{ addr=27242, type="Float32", knx="1/1/124"},	-- Minimum Voltage L3-L1
	{ addr=27244, type="Float32", knx="1/1/125"},	-- Minimum Voltage L-L Avg
	{ addr=27246, type="Float32", knx="1/1/126"},	-- Minimum Voltage L1-N
	{ addr=27248, type="Float32", knx="1/1/127"},	-- Minimum Voltage L2-N
	{ addr=27250, type="Float32", knx="1/1/128"},	-- Minimum Voltage L3-N
	{ addr=27254, type="Float32", knx="1/1/129"},	-- Minimum Voltage L-N Avg
	{ addr=27272, type="Float32", knx="1/1/130"},	-- Minimum Active Power Phase 1
	{ addr=27274, type="Float32", knx="1/1/131"},	-- Minimum Active Power Phase 2
	{ addr=27276, type="Float32", knx="1/1/132"},	-- Minimum Active Power Phase 3
	{ addr=27278, type="Float32", knx="1/1/133"},	-- Minimum Active Power Total
	{ addr=27280, type="Float32", knx="1/1/134"},	-- Minimum Reactive Power Phase 1
	{ addr=27282, type="Float32", knx="1/1/135"},	-- Minimum Reactive Power Phase 2
	{ addr=27284, type="Float32", knx="1/1/136"},	-- Minimum Reactive Power Phase 3
	{ addr=27286, type="Float32", knx="1/1/137"},	-- Minimum Reactive Power Total
	{ addr=27288, type="Float32", knx="1/1/138"},	-- Minimum Apparent Power Phase 1
	{ addr=27290, type="Float32", knx="1/1/139"},	-- Minimum Apparent Power Phase 2
	{ addr=27292, type="Float32", knx="1/1/140"},	-- Minimum Apparent Power Phase 3
	{ addr=27294, type="Float32", knx="1/1/141"},	-- Minimum Apparent Power Total
	{ addr=27306, type="4QFPPF", knx="1/1/142"},	-- Minimum Power Factor Phase 1
	{ addr=27308, type="4QFPPF", knx="1/1/143"},	-- Minimum Power Factor Phase 2
	{ addr=27310, type="4QFPPF", knx="1/1/144"},	-- Minimum Power Factor Phase 3
	{ addr=27312, type="4QFPPF", knx="1/1/145"},	-- Minimum Power Factor Total
	{ addr=27336, type="Float32", knx="1/1/146"},	-- Minimum Tangent Phi, Total
	{ addr=27338, type="Float32", knx="1/1/147"},	-- Minimum THD Current I1
	{ addr=27340, type="Float32", knx="1/1/148"},	-- Minimum THD Current I2
	{ addr=27342, type="Float32", knx="1/1/149"},	-- Minimum THD Current I3
	{ addr=27344, type="Float32", knx="1/1/150"},	-- Minimum THD Current N
	{ addr=27360, type="Float32", knx="1/1/151"},	-- Minimum THD Voltage L1-L2
	{ addr=27362, type="Float32", knx="1/1/152"},	-- Minimum THD Voltage L2-L3
	{ addr=27364, type="Float32", knx="1/1/153"},	-- Minimum THD Voltage L3-L1
	{ addr=27366, type="Float32", knx="1/1/154"},	-- Minimum THD Voltage L-L Avg
	{ addr=27368, type="Float32", knx="1/1/155"},	-- Minimum THD Voltage L1-N
	{ addr=27370, type="Float32", knx="1/1/156"},	-- Minimum THD Voltage L2-N
	{ addr=27372, type="Float32", knx="1/1/157"},	-- Minimum THD Voltage L3-N
	{ addr=27376, type="Float32", knx="1/1/158"},	-- Minimum THD Voltage L-N Avg
	{ addr=27616, type="Float32", knx="1/1/159"},	-- Minimum Frequency
	-- Maximum Values  
	{ addr=27694, type="Float32", knx="1/1/160"},	-- Maximum Current I1
	{ addr=27696, type="Float32", knx="1/1/161"},	-- Maximum Current I2
	{ addr=27698, type="Float32", knx="1/1/162"},	-- Maximum Current I3
	{ addr=27700, type="Float32", knx="1/1/163"},	-- Maximum Current N
	{ addr=27704, type="Float32", knx="1/1/164"},	-- Maximum Current Avg 
	{ addr=27714, type="Float32", knx="1/1/165"},	-- Maximum Voltage L1-L2
	{ addr=27716, type="Float32", knx="1/1/166"},	-- Maximum Voltage L2-L3
	{ addr=27718, type="Float32", knx="1/1/167"},	-- Maximum Voltage L3-L1
	{ addr=27720, type="Float32", knx="1/1/168"},	-- Maximum Voltage L-L Avg
	{ addr=27722, type="Float32", knx="1/1/169"},	-- Maximum Voltage L1-N
	{ addr=27724, type="Float32", knx="1/1/170"},	-- Maximum Voltage L2-N
	{ addr=27726, type="Float32", knx="1/1/171"},	-- Maximum Voltage L3-N
	{ addr=27730, type="Float32", knx="1/1/172"},	-- Maximum Voltage L-N Avg
	{ addr=27748, type="Float32", knx="1/1/173"},	-- Maximum Active Power Phase 1
	{ addr=27750, type="Float32", knx="1/1/174"},	-- Maximum Active Power Phase 2
	{ addr=27752, type="Float32", knx="1/1/175"},	-- Maximum Active Power Phase 3
	{ addr=27754, type="Float32", knx="1/1/176"},	-- Maximum Active Power Total 
	{ addr=27756, type="Float32", knx="1/1/177"},	-- Maximum Reactive Power Phase 1
	{ addr=27758, type="Float32", knx="1/1/178"},	-- Maximum Reactive Power Phase 2
	{ addr=27760, type="Float32", knx="1/1/179"},	-- Maximum Reactive Power Phase 3
	{ addr=27762, type="Float32", knx="1/1/180"},	-- Maximum Reactive Power Total
	{ addr=27764, type="Float32", knx="1/1/181"},	-- Maximum Apparent Power Phase 1
	{ addr=27766, type="Float32", knx="1/1/182"},	-- Maximum Apparent Power Phase 2
	{ addr=27768, type="Float32", knx="1/1/183"},	-- Maximum Apparent Power Phase 3
	{ addr=27770, type="Float32", knx="1/1/184"},	-- Maximum Apparent Power Total
	{ addr=27782, type="4QFPPF", knx="1/1/185"},	-- Maximum Power Factor Phase 1
	{ addr=27784, type="4QFPPF", knx="1/1/186"},	-- Maximum Power Factor Phase 2
	{ addr=27786, type="4QFPPF", knx="1/1/187"},	-- Maximum Power Factor Phase 3
	{ addr=27788, type="4QFPPF", knx="1/1/188"},	-- Maximum Power Factor Total
	{ addr=27812, type="Float32", knx="1/1/189"},	-- Maximum Tangent Phi, Total
	{ addr=27814, type="Float32", knx="1/1/190"},	-- Maximum THD Current I1
	{ addr=27816, type="Float32", knx="1/1/191"},	-- Maximum THD Current I2
	{ addr=27818, type="Float32", knx="1/1/192"},	-- Maximum THD Current I3
	{ addr=27820, type="Float32", knx="1/1/193"},	-- Maximum THD Current N
	{ addr=27836, type="Float32", knx="1/1/194"},	-- Maximum THD Voltage L1-L2
	{ addr=27838, type="Float32", knx="1/1/195"},	-- Maximum THD Voltage L2-L3
	{ addr=27840, type="Float32", knx="1/1/196"},	-- Maximum THD Voltage L3-L1
	{ addr=27842, type="Float32", knx="1/1/197"},	-- Maximum THD Voltage L-L
	{ addr=27844, type="Float32", knx="1/1/198"},	-- Maximum THD Voltage L1-N
	{ addr=27846, type="Float32", knx="1/1/199"},	-- Maximum THD Voltage L2-N
	{ addr=27848, type="Float32", knx="1/1/200"},	-- Maximum THD Voltage L3-N
	{ addr=27852, type="Float32", knx="1/1/201"},	-- Maximum THD Voltage L-N
	{ addr=28092, type="Float32", knx="1/1/202"},	-- Maximum Frequency  
	-- MinMax with Time Stamp
	{ addr=45134, type="Float32", knx="1/1/203"},	-- Minimum Current of I1,I2,I3 - Value
	{ addr=45140, type="Float32", knx="1/1/204"},	-- Minimum Power Factor Total - Value
	{ addr=45146, type="Float32", knx="1/1/205"},	-- Maximum Current of I1,I2,I3 - Value
	{ addr=45152, type="Float32", knx="1/1/206"},	-- Maximum Active Power Total - Value
	{ addr=45158, type="Float32", knx="1/1/207"},	-- Maximum Apparent Power Total - Value
	{ addr=45164, type="Float32", knx="1/1/208"},	-- Maximum Power Factor Total - Value
	-- Power Quality
	{ addr=45100, type="Float32", knx="1/1/209"},	-- THD Current I1
	{ addr=45102, type="Float32", knx="1/1/210"},	-- THD Current I2
	{ addr=45104, type="Float32", knx="1/1/211"},	-- THD Current I3
	{ addr=45106, type="Float32", knx="1/1/212"},	-- THD Current Neutral
	{ addr=45108, type="Float32", knx="1/1/213"},	-- THD Phase Current Worst
	{ addr=45110, type="Float32", knx="1/1/214"},	-- THD Voltage L1-L2
	{ addr=45112, type="Float32", knx="1/1/215"},	-- THD Voltage L2-L3
	{ addr=45114, type="Float32", knx="1/1/216"},	-- THD Voltage L3-L1
	{ addr=45116, type="Float32", knx="1/1/217"},	-- THD Voltage L-L Avg
	{ addr=45118, type="Float32", knx="1/1/218"},	-- THD Voltage L-L Worst
	{ addr=45120, type="Float32", knx="1/1/219"},	-- THD Voltage L1-N
	{ addr=45122, type="Float32", knx="1/1/220"},	-- THD Voltage L2-N
	{ addr=45124, type="Float32", knx="1/1/221"},	-- THD Voltage L3-N
	{ addr=45126, type="Float32", knx="1/1/222"},	-- THD Voltage L-N Avg
	{ addr=45128, type="Float32", knx="1/1/223"},	-- THD Voltage L-N Worst
	-- Alarms 
	{ addr=11021, type="Bitmap", knx="1/1/224"},	-- Alarm ID (1-16)
	{ addr=11022, type="Bitmap", knx="1/1/225"},	-- Alarm ID (17-32)
	{ addr=11023, type="Bitmap", knx="1/1/226"},	-- Alarm ID (33-40)
	{ addr=11024, type="Bitmap", knx="1/1/227"},	-- Alarm ID (41-56)
	{ addr=11040, type="Bitmap", knx="1/1/228"},	-- Alarm ID (1-16) enable/disable
	{ addr=11041, type="Bitmap", knx="1/1/229"},	-- Alarm ID (17-32) enable/disable
	{ addr=11042, type="Bitmap", knx="1/1/230"},	-- Alarm ID (33-40) enable/disable
	{ addr=11043, type="Bitmap", knx="1/1/231"},	-- Alarm ID (41-56) enable/disable
	{ addr=11078, type="Bitmap", knx="1/1/232"},	-- Alarm ID (1-16) Unacknowledged Alarm
	{ addr=11079, type="Bitmap", knx="1/1/233"},	-- Alarm ID (17-32) Unacknowledged Alarm
	{ addr=11080, type="Bitmap", knx="1/1/234"},	-- Alarm ID (33-40) Unacknowledged Alarm
	{ addr=11081, type="Bitmap", knx="1/1/235"},	-- Alarm ID (41-56) Unacknowledged Alarm  
	{ addr=11113, type="UInt16", knx="1/1/236"},	-- Size of Event Queue 
	{ addr=11114, type="UInt16", knx="1/1/237"},	-- Number of entries in Event Queue
	{ addr=11115, type="UInt16", knx="1/1/238"},	-- Entry number of Most Recent Event
	{ addr=11116, type="UInt16", knx="1/1/239"},	-- Entry number Entry 001
	{ addr=11121, type="UInt16", knx="1/1/240"},	-- Record Type 001
	{ addr=11122, type="UInt16", knx="1/1/241"},	-- Register Number or Event Code 001
	{ addr=11123, type="UInt16", knx="1/1/242"},	-- Value 001
	{ addr=11127, type="UInt16", knx="1/1/243"},	-- Sequence Number 001
	{ addr=11344, type="UInt16", knx="1/1/244"},	-- Entry number 020
	{ addr=11349, type="UInt16", knx="1/1/245"},	-- Record Type 020
	{ addr=11350, type="UInt16", knx="1/1/246"},	-- Register Number or Event Code 020
	{ addr=11351, type="UInt16", knx="1/1/247"},	-- Value 020
	{ addr=11355, type="UInt16", knx="1/1/248"},	-- Sequence Number 020 
	{ addr=12316, type="UInt16", knx="1/1/249"},	-- Size of History Log
	{ addr=12317, type="UInt16", knx="1/1/250"},	-- Number of entries in History Log
	{ addr=12318, type="UInt16", knx="1/1/251"},	-- Entry number of Most Recent Event - history
	{ addr=12319, type="UInt16", knx="1/1/252"},	-- Entry number Entry 001 - history
	{ addr=12324, type="UInt16", knx="1/1/253"},	-- Record Type 001 - history
	{ addr=12325, type="UInt16", knx="1/1/254"},	-- Register Number or Event Code 001 - history
	{ addr=12326, type="UInt16", knx="1/1/255"},	-- Value 001 - history
	{ addr=12330, type="UInt16", knx="1/2/0"},	-- Sequence Number 001 - history
	{ addr=12547, type="UInt16", knx="1/2/1"},	-- Entry number Entry 020 - history
	{ addr=12552, type="UInt16", knx="1/2/2"},	-- Record Type 020 - history
	{ addr=12553, type="UInt16", knx="1/2/3"},	-- Register Number or Event Code 020 - history
	{ addr=12554, type="UInt16", knx="1/2/4"},	-- Value 020 - history
	{ addr=12558, type="UInt16", knx="1/2/5"},	-- Sequence Number 020 - history  
	{ addr=14005, type="Float32", knx="1/2/6"},	-- Pickup Setpoint ID1
	{ addr=14007, type="UInt32", knx="1/2/7"},	-- Pickup Time Delay ID1
	{ addr=14009, type="Float32", knx="1/2/8"},	-- Dropout Setpoint ID1
	{ addr=14011, type="UInt32", knx="1/2/9"},	-- Dropout Time Delay ID1
	{ addr=14013, type="Bitmap", knx="1/2/10"},	-- Digital Outputs to Associate ID1	
	{ addr=14105, type="Float32", knx="1/2/11"},	-- Pickup Setpoint ID6
	{ addr=14107, type="UInt32", knx="1/2/12"},	-- Pickup Time Delay ID6
	{ addr=14109, type="Float32", knx="1/2/13"},	-- Dropout Setpoint ID6
	{ addr=14111, type="UInt32", knx="1/2/14"},	-- Dropout Time Delay ID6
	{ addr=14113, type="Bitmap", knx="1/2/15"},	-- Digital Outputs to Associate ID6	
	{ addr=14145, type="Float32", knx="1/2/16"},	-- Pickup Setpoint ID8
	{ addr=14147, type="UInt32", knx="1/2/17"},	-- Pickup Time Delay ID8
	{ addr=14149, type="Float32", knx="1/2/18"},	-- Dropout Setpoint ID8
	{ addr=14151, type="UInt32", knx="1/2/19"},	-- Dropout Time Delay ID8
	{ addr=14153, type="Bitmap", knx="1/2/20"},	-- Digital Outputs to Associate ID8
	{ addr=14165, type="Float32", knx="1/2/21"},	-- Pickup Setpoint ID9
	{ addr=14167, type="UInt32", knx="1/2/22"},	-- Pickup Time Delay ID9
	{ addr=14169, type="Float32", knx="1/2/23"},	-- Dropout Setpoint ID9
	{ addr=14171, type="UInt32", knx="1/2/24"},	-- Dropout Time Delay ID9
	{ addr=14173, type="Bitmap", knx="1/2/25"},	-- Digital Outputs to Associate ID9
	{ addr=14205, type="Float32", knx="1/2/26"},	-- Pickup Setpoint ID11
	{ addr=14207, type="UInt32", knx="1/2/27"},	-- Pickup Time Delay ID11
	{ addr=14209, type="Float32", knx="1/2/28"},	-- Dropout Setpoint ID11
	{ addr=14211, type="UInt32", knx="1/2/29"},	-- Dropout Time Delay ID11
	{ addr=14213, type="Bitmap", knx="1/2/30"},	-- Digital Outputs to Associate ID11	
	{ addr=14825, type="Float32", knx="1/2/31"},	-- Pickup Setpoint ID30
	{ addr=14827, type="UInt32", knx="1/2/32"},	-- Pickup Time Delay ID30
	{ addr=14829, type="Float32", knx="1/2/33"},	-- Dropout Setpoint ID30
	{ addr=14831, type="UInt32", knx="1/2/34"},	-- Dropout Time Delay ID30
	{ addr=14833, type="Bitmap", knx="1/2/35"},	-- Digital Outputs to Associate ID30
}
pwm:readRegisters(regTable)
